using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SPStudio
{
	/// <summary>
	/// Form to prompt the user
	/// for data needed to
	/// create a new instance of
	/// Workspace.
	/// </summary>
	public class NewWorkspaceForm : System.Windows.Forms.Form
	{
		#region Public Vars
		public double fov = 36.0;
		public String name = "NONE";
		public bool creationCanceled = false;
		#endregion

		#region Windows Generated Vars
		private System.Windows.Forms.Panel NamePanel;
		private System.Windows.Forms.Label NameLabel;
		private System.Windows.Forms.TextBox NameInputTextBox;
		private System.Windows.Forms.Button DoneButton;
		private System.Windows.Forms.Button Cancel_Button;
		private System.Windows.Forms.Panel FOVPanel;
		private System.Windows.Forms.Label FOVLabel;
		private System.Windows.Forms.TextBox FOVTextBox;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		#endregion

		#region Constructor
		/// <summary>
		/// Standard constructor that initializes components.
		/// </summary>
		public NewWorkspaceForm()
		{
			InitializeComponent();
		}
		#endregion

		#region Dispose Operation
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}
		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.NamePanel = new System.Windows.Forms.Panel();
			this.NameInputTextBox = new System.Windows.Forms.TextBox();
			this.NameLabel = new System.Windows.Forms.Label();
			this.DoneButton = new System.Windows.Forms.Button();
			this.Cancel_Button = new System.Windows.Forms.Button();
			this.FOVPanel = new System.Windows.Forms.Panel();
			this.FOVTextBox = new System.Windows.Forms.TextBox();
			this.FOVLabel = new System.Windows.Forms.Label();
			this.NamePanel.SuspendLayout();
			this.FOVPanel.SuspendLayout();
			this.SuspendLayout();
			// 
			// NamePanel
			// 
			this.NamePanel.Controls.Add(this.NameInputTextBox);
			this.NamePanel.Controls.Add(this.NameLabel);
			this.NamePanel.Dock = System.Windows.Forms.DockStyle.Top;
			this.NamePanel.Location = new System.Drawing.Point(0, 0);
			this.NamePanel.Name = "NamePanel";
			this.NamePanel.Size = new System.Drawing.Size(288, 24);
			this.NamePanel.TabIndex = 0;
			// 
			// NameInputTextBox
			// 
			this.NameInputTextBox.Dock = System.Windows.Forms.DockStyle.Fill;
			this.NameInputTextBox.Location = new System.Drawing.Point(56, 0);
			this.NameInputTextBox.Name = "NameInputTextBox";
			this.NameInputTextBox.Size = new System.Drawing.Size(232, 20);
			this.NameInputTextBox.TabIndex = 1;
			this.NameInputTextBox.Text = "";
			// 
			// NameLabel
			// 
			this.NameLabel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.NameLabel.Dock = System.Windows.Forms.DockStyle.Left;
			this.NameLabel.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.NameLabel.Location = new System.Drawing.Point(0, 0);
			this.NameLabel.Name = "NameLabel";
			this.NameLabel.Size = new System.Drawing.Size(56, 24);
			this.NameLabel.TabIndex = 0;
			this.NameLabel.Text = "NAME:";
			this.NameLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// DoneButton
			// 
			this.DoneButton.Dock = System.Windows.Forms.DockStyle.Top;
			this.DoneButton.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.DoneButton.Location = new System.Drawing.Point(0, 48);
			this.DoneButton.Name = "DoneButton";
			this.DoneButton.Size = new System.Drawing.Size(288, 24);
			this.DoneButton.TabIndex = 1;
			this.DoneButton.Text = "DONE";
			this.DoneButton.Click += new System.EventHandler(this.DoneButton_Click);
			// 
			// Cancel_Button
			// 
			this.Cancel_Button.Dock = System.Windows.Forms.DockStyle.Top;
			this.Cancel_Button.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Cancel_Button.Location = new System.Drawing.Point(0, 72);
			this.Cancel_Button.Name = "Cancel_Button";
			this.Cancel_Button.Size = new System.Drawing.Size(288, 24);
			this.Cancel_Button.TabIndex = 2;
			this.Cancel_Button.Text = "CANCEL";
			this.Cancel_Button.Click += new System.EventHandler(this.Cancel_Button_Click);
			// 
			// FOVPanel
			// 
			this.FOVPanel.Controls.Add(this.FOVTextBox);
			this.FOVPanel.Controls.Add(this.FOVLabel);
			this.FOVPanel.Dock = System.Windows.Forms.DockStyle.Top;
			this.FOVPanel.Location = new System.Drawing.Point(0, 24);
			this.FOVPanel.Name = "FOVPanel";
			this.FOVPanel.Size = new System.Drawing.Size(288, 24);
			this.FOVPanel.TabIndex = 3;
			// 
			// FOVTextBox
			// 
			this.FOVTextBox.Dock = System.Windows.Forms.DockStyle.Fill;
			this.FOVTextBox.Location = new System.Drawing.Point(56, 0);
			this.FOVTextBox.Name = "FOVTextBox";
			this.FOVTextBox.Size = new System.Drawing.Size(232, 20);
			this.FOVTextBox.TabIndex = 1;
			this.FOVTextBox.Text = "36.0";
			// 
			// FOVLabel
			// 
			this.FOVLabel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.FOVLabel.Dock = System.Windows.Forms.DockStyle.Left;
			this.FOVLabel.Location = new System.Drawing.Point(0, 0);
			this.FOVLabel.Name = "FOVLabel";
			this.FOVLabel.Size = new System.Drawing.Size(56, 24);
			this.FOVLabel.TabIndex = 0;
			this.FOVLabel.Text = "FOV:";
			this.FOVLabel.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// NewWorkspaceForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(288, 94);
			this.ControlBox = false;
			this.Controls.Add(this.Cancel_Button);
			this.Controls.Add(this.DoneButton);
			this.Controls.Add(this.FOVPanel);
			this.Controls.Add(this.NamePanel);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "NewWorkspaceForm";
			this.Text = "New Workspace";
			this.NamePanel.ResumeLayout(false);
			this.FOVPanel.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Button Handling
		/// <summary>
		/// Set the creationCanceled flag.
		/// Hide the dialog to return
		/// control to the desktop.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void Cancel_Button_Click(object sender, System.EventArgs e)
		{
			creationCanceled = true;
			Hide();
		}

		/// <summary>
		/// Set the name of the workspace.
		/// Verify the field of view.
		/// Return control to the desktop.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DoneButton_Click(object sender, System.EventArgs e)
		{
			name = NameInputTextBox.Text.Trim();
			try
			{
				fov = Convert.ToDouble(FOVTextBox.Text.Trim());
				if(fov>10.0)
				{
					Hide();
				}
				else
				{
					MessageBox.Show(
						"FOV is too small.");
				}
			}
			catch (System.OverflowException) 
			{
				MessageBox.Show(
					"Number is too large.");
			}
			catch (System.FormatException) 
			{
				MessageBox.Show(
					"The string was not formatted as a decimal value.");
			}
			catch (System.ArgumentException) 
			{
				MessageBox.Show(
					"Please enter a number.");
			}
		}
		#endregion
	}
}
